## Libsig: Digital Signature Library for Media Files

Libsig is a digital signature library designed specifically for securing image and video files through cryptographic signatures. 

This project is based on [OpenSSL][1], make sure that you have installed OpenSSL before using this code. For example, you can install openssl on your Mac OSX using the following command:

    brew install openssl@3

Checking the verison of openssl:

    openssl version
    OpenSSL 3.6.0 1 Oct 2025 (Library: OpenSSL 3.6.0 1 Oct 2025)
    
Setting development environment:

    export PATH="/opt/homebrew/opt/openssl@3/bin:$PATH"
    export CPPFLAGS="-I/opt/homebrew/opt/openssl@3/include"
    export LDFLAGS="-L/opt/homebrew/opt/openssl@3/lib"

### Basic Usage

Users can compile libsig simply by using the following command:
    
    make all
    
The output will be:

    g++ -Wall -std=c++17 -o libsig libsig.cc -lssl -lcrypto
    g++ -Wall -std=c++17 -o test test.cc -lssl -lcrypto
    
We first use libsig to generate private key and public key locally. 
    
    ./libsig keys key1
    
The output will be:

    -----BEGIN PUBLIC KEY-----
    MFYwEAYHKoZIzj0CAQYFK4EEAAoDQgAE+XY4LwQeajJL2VH129MiFR/pCk8kNfkR
    k5scoeHfVkaK7HeVOyyDF9K4m4cTDqJYzBwXJmkNQVQm0k9TbEV1dA==
    -----END PUBLIC KEY-----
    
    -----BEGIN PRIVATE KEY-----
    MIGEAgEAMBAGByqGSM49AgEGBSuBBAAKBG0wawIBAQQg24TgQiVqA9g5um6663aR
    Ax7m2A9Rlqv2wHCXtY1qRtKhRANCAAT5djgvBB5qMkvZUfXb0yIVH+kKTyQ1+RGT
    mxyh4d9WRorsd5U7LIMX0ribhxMOoljMHBcmaQ1BVCbST1NsRXV0
    -----END PRIVATE KEY-----
    
    public key has been written to: key1/public_key.pem
    private key has been written to: key1/private_key.pem

Then, we can sign an image or a video using the following command:
    
    ./libsig sign image-0.jpg key1/private_key.pem
    
The output could be:

        The signature is: MEUCIQC53xo+aP5/ju8g7svnWibffRv0c5AAGxol0U2Xo76T9gIgA7UGaUH5mLSnltWRhdhaE3p2U7FEbfa4sa0o4r9jc0U=
    New file is created: signed-image-0.jpg

The `image-0.jpg` argument indicates the input media file, users can replace this file by others, e.g., `video-1.mp4`

    ./libsig sign video-1.mp4 ./key1/private_key.pem

After that, we can verify the signature using:
    
    ./libsig verify ./signed-image-0.jpg ./key1/public_key.pem
    
The output will be:

    Verified success.

The `./signed-image-0.jpg` argument indicates the input file signed by libsig.

Also, we can verify the signed mp4 file:

    ./libsig verify signed-video-1.mp4 ./key1/public_key.pem 

The `./key1/public_key.pem` argument indicates the file path of user's public key.

### Chained Signatures

We can give a second signature to the signed images and videos. We first generate a new public key and private key:

    ./libsig keys key2

The output will be:

    -----BEGIN PUBLIC KEY-----
    MFYwEAYHKoZIzj0CAQYFK4EEAAoDQgAE62kXnYYntxgo6gq31fzewbfUgOf3O7nr
    9W5gFT1/vn8Zk7toufrWLlRG1tcwd98YsitKBGAvX6XEB3LNHnKUjg==
    -----END PUBLIC KEY-----
    
    -----BEGIN PRIVATE KEY-----
    MIGEAgEAMBAGByqGSM49AgEGBSuBBAAKBG0wawIBAQQgn+g7g5QF68R16U6LsVum
    2rMdiOleJjh8/Khhuk2OxymhRANCAATraRedhie3GCjqCrfV/N7Bt9SA5/c7uev1
    bmAVPX++fxmTu2i5+tYuVEbW1zB33xiyK0oEYC9fpcQHcs0ecpSO
    -----END PRIVATE KEY-----
    
    public key has been written to: key2/public_key.pem
    private key has been written to: key2/private_key.pem

Then, we can give a second signature:

    ./libsig sign signed-image-0.jpg ./key2/private_key.pem

The output will be:

    The signature is: MEYCIQCKaNzJNNcgHaugrwKfT3bfWinx0MFvYmyiqV4segncBgIhAJo9RnR8dbGGGJf6GFvySiYVERykEeYray2yLE2fJU4d
    New file is created: signed-signed-image-0.jpg

Then, we verify the second signature:

    ./libsig verify signed-signed-image-0.jpg ./key2/public_key.pem

The output will be:

    Verified success.

### Testing

To assume that you can get expected output of libsig, we suggest users to run the testing cases. Make sure you have already compiled libsig by using the following command:

    make all
 
 or

    make test

Then run the test program:   
    
    ./test
    
The output of the testing program will be:

    12 cases passed. 0 cases failed.

  [1]: https://github.com/openssl/openssl
