/*
 * The MIT License (MIT)

 * Copyright (c) 2025 libsig Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef LIBSIG_ARGS_PARSER_H_
#define LIBSIG_ARGS_PARSER_H_

#include <cstdlib>
#include <iostream>
#include <string>
#include <vector>
#include <regex>

namespace libsig {

class ArgsParser {
 public:
  ArgsParser(int argc, char** argv) {
    for (int i = 0; i < argc; ++i) {
      args_.push_back(argv[i]);
    }
    command_ = "unset";
    file_ = "unset";
    privKey_ = "unset";
    pubKey_ = "unset";
  } 

  bool ArgsCheck() {
    if (args_.size() < 2) {
      return false;
    }
    if (args_[1] != "keys" && 
        args_[1] != "sign" && 
        args_[1] != "verify") {
      return false;
    }
    if (args_[1] == "keys") {
      if (args_.size() != 3) {
        return false;
      }
      command_ = "keys";
      file_ = args_[2];
    }
    if (args_[1] == "sign") {
      if (args_.size() != 4) {
        return false;
      }
      command_ = "sign";
      file_ = args_[2];
      privKey_ = args_[3];
    }
    if (args_[1] == "verify") {
      if (args_.size() != 4) {
        return false;
      }
      command_ = "verify";
      file_ = args_[2];
      pubKey_ = args_[3];
    }

    return true;
  }

  void HelpPage() {
    std::cout << "Please use right arguments, e.g., " << std::endl;
    std::cout << " ./libsig keys key" << std::endl;
    std::cout << " ./libsig sign image.jpg privte_key.pem" << std::endl;
    std::cout << " ./libsig verify image.jpg public_key.pem" << std::endl;
  }

  std::string command() {
    CHECK();
    return command_;
  }

  std::string file() {
    CHECK();
    return file_;
  }

  std::string public_key() {
    CHECK();
    return pubKey_;
  }

  std::string private_key() {
    CHECK();
    return privKey_;
  }

 private:
  std::vector<std::string> args_;
  std::string command_;
  std::string file_;
  std::string privKey_;
  std::string pubKey_;

  void CHECK() {
    if (ArgsCheck() == false) {
      HelpPage();
      exit(EXIT_FAILURE);
    }
  }
};

} // namespace libsig

#endif // LIBSIG_ARGS_PARSER_H_