# GenText-Checker

Fast and efficient plagiarism checking tool.

You can compile Gentext-Checker simply by using:

    g++ -std=c++11 gtchecker.cc -o gtchecker

Then you can execute gtchecker by using:

    ./gtchecker ./data/paper_1.txt ./data/paper_1_D8.txt

the output will be:

    The similarity of ./data/paper_1.txt and ./data/paper_1_D8.txt is: 0.882592

On default, gtchecker will select similarity calculator automatically by the size of two documents. Users can also specify the similarity calculator by hand:

    ./gtchecker ./data/paper_1.txt ./data/paper_1_D8.txt --med

The output will be:

    The similarity of ./data/paper_1.txt and ./data/paper_1_D8.txt is: 0.522613

This command will use Min Edit Distance (MED) to calculate similarity. We can also use cosine similarity calculator by using:

    ./gtchecker ./data/paper_1.txt ./data/paper_1_D8.txt --cosine
    
The output will be:

    The similarity of ./data/paper_1.txt and ./data/paper_1_D8.txt is: 0.882592

Users can run the benchmark we provide by using the following command:

    g++ -std=c++11 benchmark.cc -o benchmark
    ./benchmark
    
The output will be:

    ./data/paper_1.txt ./data/paper_1_D3.txt Similarity: 0.983459
    ./data/paper_1.txt ./data/paper_1_D4.txt Similarity: 0.944724
    ./data/paper_1.txt ./data/paper_1_D5.txt Similarity: 1
    ./data/paper_1.txt ./data/paper_1_D6.txt Similarity: 0.964824
    ./data/paper_1.txt ./data/paper_1_D7.txt Similarity: 0.944724
    ./data/paper_1.txt ./data/paper_1_D8.txt Similarity: 0.882592
    ...
    Execution Time: 107 ms
    Result is written to output_result.txt
    
Users can run the tests by using:

    g++ -std=c++11 test.cc -o test
    ./test
    
The output will be:

    17 cases passed. 0 cases failed.