/*
 * The MIT License (MIT)

 * Copyright (c) 2025 GenText-Checker Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GTCHECKER_COMMON_H_
#define GTCHECKER_COMMON_H_

#include <iostream>
#include <fstream>
#include <sstream>

using std::string;
using std::stringstream;

namespace gtchecker {

  // Compare the size of two strings
  // For instance, string_a = "abcd", size = 4
  //               string_b = "abcde", size = 5
  // return (5-4) / 4 = 0.25
  double SizeDifferenceRatio(const string& A, const string& B) {
    int tmp = A.size() - B.size();
    tmp = tmp > 0 ? tmp : -tmp;
    double ratio = (double)tmp / A.size();
    return ratio;
  }

  // Read all the content of a TXT file into std::string
  // input: Path of the TXT file
  // return: string data
  std::string ReadFileToString(const string& filePath) {
    std::ifstream file(filePath);
    if (!file.is_open()) {
      std::cerr << "Error: Unable to open file: " << filePath << std::endl;
      return "";
    }

    stringstream buffer;
    buffer << file.rdbuf();
    string content = buffer.str();

    file.close();
    return content;
  }
}

#endif // GTCHECKER_COMMON_H_