/*
 * The MIT License (MIT)

 * Copyright (c) 2025 GenText-Checker Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GTCHECKER_CXX_TOKEN_H_
#define GTCHECKER_CXX_TOKEN_H_

#include <string>
#include <vector>
#include <iostream>
#include <cctype>

using std::string;
using std::vector;

namespace gtchecker {

  void SplitStringToVectorUsing(const string& full, 
                                const char* delim, 
                                vector<string>* result) {
    // we assume that delim contains only one character
    if (delim[0] != '\0' && delim[1] == '\0') {
      char c = delim[0];

      int start = 0;
      int end = full.size()-1;

      while (start != end) {
        if (full[start] == c) {
          ++start;
        } else {
          while (full[end] == c && start != end) {
            --end;
          }
          break;
        }
      }
    
      int pos = start;
      for (int i = start; i <= end; ++i) {
        if (full[i] == c) {
          string str = full.substr(pos, i-pos);
          result->push_back(str);
          while (full[i] == c && i <= end) { 
            ++i;
          }
          pos = i;
        }
      }

      string str = full.substr(pos, end-pos+1);
      result->push_back(str);
    }
  }

  void FilterAlphanumeric(vector<string>* result) {
    for (int i = 0; i < result->size(); ++i) {
      if ((*result)[i].empty()) {
        continue;
      }

      // Check first element
      while ((*result)[i].empty() == false && !std::isalnum((*result)[i].front())) {
        (*result)[i].erase((*result)[i].begin());
      }

      // Check last element
      while ((*result)[i].empty() == false && !std::isalnum((*result)[i].back())) {
        (*result)[i].erase((*result)[i].end() - 1);
      }
    }
  }

  void Lowercase(vector<string>* result) {
    for (int i = 0; i < result->size(); ++i) {
      if ((*result)[i].empty()) {
        continue;
      }

      int str_size = (*result)[i].size();

      for (int j = 0; j < str_size; ++j) {
        char c = (*result)[i][j];
        (*result)[i][j] = std::tolower(c);
      }
    }
  }

  vector<string> GetSplitWords(const string& document) {
    vector<string> result;
    SplitStringToVectorUsing(document, " ", &result);
    FilterAlphanumeric(&result);
    Lowercase(&result);
    return result;
  }
}

#endif // GTCHECKER_CXX_TOKEN_H_