/*
 * The MIT License (MIT)

 * Copyright (c) 2025 GenText-Checker Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GTCHECKER_ARGS_PARSER_H_
#define GTCHECKER_ARGS_PARSER_H_

#include <cstdlib>
#include <iostream>
#include <string>
#include <vector>

namespace gtchecker {

class ArgsParser {
 public:
  ArgsParser(int argc, char** argv) {
    for (int i = 0; i < argc; ++i) {
      args_.push_back(argv[i]);
    }
  } 

  bool ArgsCheck() {
    if (args_.size() < 3) {
      return false;
    }
    if (args_[1] != "plag" && args_[1] != "sig") {
      return false;
    }
    if (args_[1] == "plag") {
      command_ = "plag";
      if (args_.size() != 4 && args_.size() != 5) {
        return false;
      }
      file_a_ = args_[2];
      file_b_ = args_[3];
      if (args_.size() == 5) {
        if (args_[4] != "--strict" && args_[4] != "--loose") {
          return false;
        }
        check_type_ = args_[4];
      } else {
        check_type_ = "--strict";
      }
    }
    if (args_[1] == "sig") {
      if (args_.size() != 3) {
        return false;
      }
      command_ = "sig";
      file_a_ = args_[2];
    }

    return true;
  }

  void HelpPage() {
    std::cout << "Please use right arguments, e.g., " << std::endl;
    std::cout << " ./gtchecker plag doc_1.txt doc_2.txt " << std::endl;
    std::cout << " ./gtchecker plag doc_1.txt doc_2.txt --strict" << std::endl;
    std::cout << " ./gtchecker plag doc_1.txt doc_2.txt --loose" << std::endl;
    std::cout << " ./gtchecker sig doc_1.txt" << std::endl;
  }

  std::string command() {
    CHECK();
    return command_;
  }

  std::string file_a() {
    CHECK();
    return file_a_;
  }

  std::string file_b() {
    CHECK();
    return file_b_;
  }

  std::string check_type() {
    CHECK();
    return check_type_;
  }

 private:
  std::vector<std::string> args_;
  std::string command_;
  std::string file_a_;
  std::string file_b_;
  std::string check_type_;

  void CHECK() {
    if (ArgsCheck() == false) {
      HelpPage();
      exit(EXIT_FAILURE);
    }
  }
};

} // namespace gtchecker

#endif // GTCHECKER_ARGS_PARSER_H_