/*
 * The MIT License (MIT)

 * Copyright (c) 2025 GenText-Checker Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GTCHECKER_SIGNATURE_H_
#define GTCHECKER_SIGNATURE_H_

#include "tokenizer.h"

#include <string>
#include <unordered_map>
#include <vector>
#include <iostream>

namespace gtchecker {

class Signature {
 public:
  Signature(const std::string& doc, 
            const std::string& hash_type = "hfws") 
   : doc_(doc), hash_type_(hash_type) { }

  std::string sign() {
    std::string signature = "";
    if (hash_type_ == "hfws") {
      gtchecker::Tokenizer tokenizer;
      std::vector<std::string> doc_words = tokenizer.GetSplitWords(doc_);
      for (int i = 0; i < doc_words.size(); ++i) {
        if (hfword_map.find(doc_words[i]) != hfword_map.end()) {
          signature += hfword_map[doc_words[i]];
        }
      }
    } else {
      std::cout << "Unknow hash type: " << hash_type_ << std::endl;
    }
    return signature;
  }

 private:
  // High frequency word map
  std::unordered_map<std::string, char> hfword_map = {
     {"the",'0'}, {"and",'1'}, {"a",'2'}, {"to",'3'}, {"i",'4'}, {"of",'5'}, {"in",'6'},
     {"was",'7'}, {"he",'8'}, {"that",'9'}, {"it",'a'}, {"for",'b'}, {"on",'c'}, {"with",'d'},
     {"you",'e'}, {"is",'f'}, {"at",'g'}, {"his",'h'}, {"my",'i'}, {"said",'j'}, {"all",'k'},
     {"as",'l'}, {"but",'m'}, {"me",'n'}, {"she",'o'}, {"had",'p'}, {"this",'q'}, {"have",'r'},
     {"from",'s'}, {"they",'t'}, {"we",'u'}, {"be",'v'}, {"are",'w'}, {"one",'x'}, {"not",'y'},
     {"when",'z'}, {"little",'A'}, {"about",'B'}, {"her",'C'}, {"him",'D'}, {"up",'E'}, {"out",'F'},
     {"if",'G'}, {"like",'H'}, {"or",'I'}, {"were",'J'}, {"by",'K'}, {"an",'L'}, {"just",'M'},
     {"so",'N'}, {"very",'O'}, {"what",'P'}, {"over",'Q'}, {"old",'R'}, {"then",'S'}, {"do",'T'},
     {"there",'U'}, {"get",'V'}, {"them",'W'}, {"know",'X'}, {"time",'Y'}, {"has",'Z'}
  };

  std::string doc_;
  std::string hash_type_;
};

} // namespace gtchecker

#endif // GTCHECKER_SIGNATURE_H_