/*
 * The MIT License (MIT)

 * Copyright (c) 2025 GenText-Checker Developers

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "common.h"
#include "args_parser.h"
#include "printer.h"
#include "similarity.h"
#include "spliter.h"
#include "signature.h"

#include <string>
#include <vector>

int main(int argc, char** argv) {
  gtchecker::ArgsParser parser(argc, argv);
  if (parser.ArgsCheck() == false) {
    parser.HelpPage();
    return -1;
  } else {
    if (parser.command() == "plag") {
      std::string document_A = gtchecker::ReadFileToString(parser.file_a());
      std::string document_B = gtchecker::ReadFileToString(parser.file_b());

      gtchecker::Spliter spliter_A(document_A);
      gtchecker::Spliter spliter_B(document_B);

      std::vector<gtchecker::Sentence> chunks_A = spliter_A.split();
      std::vector<gtchecker::Sentence> chunks_B = spliter_B.split();

      gtchecker::Similarity similarity(chunks_A, 
                                       chunks_B, 
                                       parser.check_type());

      std::vector<std::vector<double>> similarity_results = similarity.Calculate();

      gtchecker::Printer printer(parser.file_a(), 
                                 parser.file_b(), 
                                 similarity_results, 
                                 chunks_A, 
                                 chunks_B);
      printer.print();
    } else if (parser.command() == "sig") {
      std::string document_A = gtchecker::ReadFileToString(parser.file_a());

      gtchecker::Signature signature(document_A, parser.sig_type());

      std::cout << "Signature: " << signature.sign() << std::endl;

    } else {
      std::cout << "Unknow command." << std::endl;
      parser.HelpPage(); 
    }
  }

  return 0;
}