## GenText-Checker-0.36

Efficient article plagiarism checking tool.

### Basic Usage

Users can compile Gentext-Checker (gtchecker) simply by using the following command:

    make all

The output of the compiler will be:

    g++ -Wall -std=c++17 -o gtchecker gtchecker.cc
    g++ -Wall -std=c++17 -o test test.cc

Then you can execute gtchecker by:

    ./gtchecker plag ./doc_A.txt ./doc_B.txt

The output of gtchecker will be:

    Doc_A: ./doc_A.txt  Doc_B: ./doc_B.txt
    
    Doc_A: [0-50] Deeper neural networks are more difficult to train.
    Doc_B: [0-43] Deeper learning are more difficult to train.
    Doc_A: [52-182] We present a residual learning framework to ease the training of networks that are substantially deeper than those used previously.
    ...
    Doc_A: [1070-1290] Deep residual nets are foundations of our submissions to ILSVRC & COCO 2015 competitions1, where we also won the 1st places on the tasks of ImageNet detection, ImageNet localization, COCO detection, and COCO segmentation.
    Doc_B: [1070-1296] Deep residual networks are foundations of our submissions to ILSVRC & COCO 2015 competitions1, where we also won the first places on the tasks of ImageNet detection, ImageNet localization, COCO detection, and COCO segmentation.
    
    Doc_A has 100% similarity with Doc_B.
    Doc_B has 100% similarity with Doc_A.
    
This indicates that every sentences in Doc_A are similar with Doc_B. Also, every sentences in Doc_B are similar with Doc_A.

    Doc_A: [0-50] Deeper neural networks are more difficult to train.
    Doc_B: [0-43] Deeper learning are more difficult to train.

 `[0-50]` and `[0-43]` indicate the character index of each document.

In 0.36 version, gtchecker uses a very strict sentence-based plagiarism checking method by default. This means that if you just change a few words of a sentence, gtchecker can still check it out. 

If you think this kind of checking is overly strict, e.g., you consider these two sentences "*Deeper neural networks are more difficult to train.*" and "*Deeper learning are more difficult to train.*" are not similar, you can uses a loose checking method by the following command:

    ./gtchecker plag ./doc_A.txt ./doc_B.txt --loose

The output of gtchecker will be:

    Doc_A: ./doc_A.txt  Doc_B: ./doc_B.txt
    
    Doc_A: [184-330] We explicitly reformulate the layers as learning residual functions with reference to the layer inputs, instead of learning unreferenced functions.
    Doc_B: [180-326] We explicitly reformulate the layers as learning residual functions with reference to the layer inputs, instead of learning unreferenced functions.
    Doc_A: [641-721] An ensemble of these residual nets achieves 3.57% error on the ImageNet test set.
    Doc_B: [646-726] An ensemble of these residual nets achieves 3.57% error on the ImageNet test set.
    Doc_A: [793-854] We also present analysis on CIFAR-10 with 100 and 1000 layers.
    Doc_B: [800-861] We also present analysis on CIFAR-10 with 100 and 1000 layers.
    Doc_A: [856-943] The depth of representations is of central importance for many visual recognition tasks.
    Doc_B: [863-950] The depth of representations is of central importance for many visual recognition tasks.
    
    Doc_A has 36.3636% similarity with Doc_B.
    Doc_B has 36.3636% similarity with Doc_A.

In this example, gtchecker uses loose checking method that compare two sentences word-by-word. Only two sentences are exactly the same (every words are the same, while ignore the upper/lower cases and noise characters), gtchecker will check it out.

### HFWS Signature

In 0.36 version, gtchecker supports a new method called *high frequency words signature (HFWS)*, which helps users filtering high probability plagiarism actions from a large numbers of documents. This method has the potential to reduce the computation and storage overhead of LLMs services for checking article plagiarism. Users can use this method by the following commands:

    ./gtchecker sig ./doc_A.txt --hfws

The output will be:

    ./doc_A.txt Signature: w3u23059wu0ld305u9w31sc0ud25E3mL5c0q0c0ucd105f5b3u2c0w53u0c051

This command generates a digital signature for doc_A. Also, users can use the same way to generate a signature for doc_B:

    ./gtchecker sig ./doc_B.txt --hfws

The output will be:

    ./doc_B.txt Signature: w3u2b059wu0ld305u9w31sc0ud25E3mL5c0q0c0ucd105f5b3u2c0w53u0c051

Compared to checking the whole content of the input documents, we can compare the signatures of the given documents in the first setp for filtering high probability plagiarism actions.

### 6bits Signature

In 0.36 version, gtchecker also support a new method called *6bits compression*, which can compress a document into a 6 bits digital signature. This method also has the potential to reduce the computation and storage overhead of LLMs services for checking article plagiarism. Users can use this method by the following commands: 

    ./gtchecker sig ./doc_A.txt --6bits

The output will be:

    ./doc_A.txt Signature: 001101
    
Also, users can use the same way to generate a signature for doc_B:

    ./gtchecker sig ./doc_A.txt --6bits

The output will be:

    ./doc_A.txt Signature: 001101

### Run Benchmark

We provide a benchmark that contains 60 cases to test plagiarism-checking and signature generation of gtchecker. To run the benchmark, you can use the following command:
    
    ./benchmark.sh

The output of the benchmark will be:

    make: `gtchecker' is up to date.
    Results of plagiarism-checking are written to strict_output.txt and loose_output.txt
    Results of signature are written to signature_output.txt

### Testing

To assume that you can get expected output of gtchecker, we suggest users to run the testing cases. Make sure you have already compiled gtchecker by using the following command:

    make all
 
 or

    make test

Then run the test program:   
    
    ./test
    
The output of the testing program will be:

    24 cases passed. 0 cases failed.