#!/bin/bash

if [ -f "strict_output.txt" ]; then
    rm "strict_output.txt"
fi

if [ -f "loose_output.txt" ]; then
    rm "loose_output.txt"
fi

if [ -f "signature_output.txt" ]; then
    rm "signature_output.txt"
fi

make gtchecker

PAPER_COUNT=10
START_MODE=3 
MODE=8

for ((i=1; i<=PAPER_COUNT; i++)); do
    for ((j=START_MODE; j<=MODE; j++)); do
        ./gtchecker plag "./data/paper_${i}.txt" "./data/paper_${i}_D${j}.txt" --strict >> strict_output.txt
        ./gtchecker plag "./data/paper_${i}.txt" "./data/paper_${i}_D${j}.txt" --loose >> loose_output.txt
    done
done

for ((i=1; i<=PAPER_COUNT; i++)); do
    ./gtchecker sig "./data/paper_${i}.txt" --hfws >> signature_output.txt
    ./gtchecker sig "./data/paper_${i}.txt" --6bits >> signature_output.txt
    for ((j=START_MODE; j<=MODE; j++)); do
        ./gtchecker sig "./data/paper_${i}_D${j}.txt" --hfws >> signature_output.txt
        ./gtchecker sig "./data/paper_${i}_D${j}.txt" --6bits >> signature_output.txt
    done
done

echo "Results of plagiarism-checking are written to strict_output.txt and loose_output.txt"
echo "Results of signature are written to signature_output.txt"